
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1240.C - Message 1240 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1240 messages.
//
//
//   REVISION HISTORY
//
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

void wait(float);  
void clear_message_line(void);   

/* not needed yet
////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1240 message from the ZMsgBuf.
//
void Dec1240(tMSGBUF *ZMsgBuf, tMSG1240 *Msg)
{
; // whatever
}                                      

end not needed yet */
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1240 message in the ZMsgBuf.
//
void Bld1240(tMSGBUF *ZMsgBuf, tMSG1240 *Msg)
{
 
  tSHORT index=0;
  
  for(index=5; index<422; index++) ZMsgBuf->word[index] = ZMsgBuf->word[index+2];

   // build the header in the buffer
   PutShort  (0x81FF                         , ZMsgBuf, 1);     // message preamble
   PutShort  (1240                           , ZMsgBuf, 2);     // message number
   PutShort  (417                            , ZMsgBuf, 3);     // message length
   PutShort  (ANREQ                          , ZMsgBuf, 4);     // message ack/nack request
                                                   
}                                            


/* not needed yet
////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1240 message from the ZMsgBuf.
//
void Show1240(tMSG1240 *Msg)
{
; // whatever
}                                                 

end not needed yet */
                                      
                                           
